import { BASE_API_URL_STG } from "@env";
import { getCartProduct } from "../redux/slices/cart/getCartProducts";
import { getPreferences } from "../redux/slices/preferences/getPreferences";
import { getMyRefundWallet } from "../redux/slices/user/myRefund/refundWallet/getMyRefundWallet";
import { getMyWishlist } from "../redux/slices/user/myWishlist/getMyWishlist";
import { getMyOrders } from "../redux/slices/user/orderHistory/getOrderHistory";
import { getReCaptcha } from "../redux/slices/auth/reCaptcha";
import { getpopularProducts } from "../redux/slices/popularProducts/popularProducts";
import { getbestSellers } from "../redux/slices/bestSellers/bestSellers";

const rootApiRequest = (dispatch, access_token = "") => {
    const CARTURL = `${BASE_API_URL_STG}/user/carts`;
    dispatch(getCartProduct({ access_token, CARTURL }));
    dispatch(getPreferences());
    dispatch(getReCaptcha());

    const popularURL = `${BASE_API_URL_STG}/user/product-categorized/popularProducts`;
    dispatch(getpopularProducts(popularURL));

    const bestSellerURL = `${BASE_API_URL_STG}/user/product-categorized/bestSeller`;
    dispatch(getbestSellers(bestSellerURL));
};

export default rootApiRequest;

export const authApiRequest = (dispatch, access_token = "") => {
    const CARTURL = `${BASE_API_URL_STG}/user/carts`;
    dispatch(getCartProduct({ access_token, CARTURL }));

    const ORDER_URL = `${BASE_API_URL_STG}/user/orders`;
    dispatch(getMyOrders({ access_token, URL: ORDER_URL }));

    const WISHLIST_URL = `${BASE_API_URL_STG}/user/wishlists`;
    dispatch(getMyWishlist({ access_token, URL: WISHLIST_URL }));

    const urlGet = `${BASE_API_URL_STG}/user/wallet`;
    dispatch(getMyRefundWallet({ access_token, URL: urlGet }));
};
